<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/rbac.php';
require_login();
require __DIR__ . '/../includes/header.php';

if (in_array(user_role(), ['admin','guru']) && $_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf();
  $judul = $_POST['judul'] ?? '';
  $isi = $_POST['isi'] ?? '';
  if ($judul && $isi) {
    $stmt = $pdo->prepare("INSERT INTO pengumuman(judul, isi, dibuat_oleh) VALUES(?,?,?)");
    $stmt->execute([$judul,$isi,current_user()['id']]);
  }
}
$rows = $pdo->query("SELECT p.*, u.name AS author FROM pengumuman p LEFT JOIN users u ON u.id=p.dibuat_oleh ORDER BY p.created_at DESC")->fetchAll();
?>
<h4>Pengumuman</h4>
<?php if (in_array(user_role(), ['admin','guru'])): ?>
<form method="post" class="card card-body mb-3">
  <?php csrf_field(); ?>
  <div class="row g-3">
    <div class="col-md-4">
      <input name="judul" class="form-control" placeholder="Judul" required>
    </div>
    <div class="col-md-8">
      <input name="isi" class="form-control" placeholder="Isi pengumuman..." required>
    </div>
  </div>
  <div class="mt-2"><button class="btn btn-primary">Tambah</button></div>
</form>
<?php endif; ?>
<ul class="list-group">
  <?php foreach ($rows as $r): ?>
    <li class="list-group-item">
      <div class="d-flex justify-content-between">
        <strong><?= htmlspecialchars($r['judul']) ?></strong>
        <small><?= htmlspecialchars($r['created_at']) ?> — <?= htmlspecialchars($r['author'] ?? 'Admin') ?></small>
      </div>
      <div><?= htmlspecialchars($r['isi']) ?></div>
    </li>
  <?php endforeach; ?>
</ul>
<?php require __DIR__ . '/../includes/footer.php'; ?>
