<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require_login();
require __DIR__ . '/../includes/header.php';

$uid = current_user()['id'];
// ambil anak2 dari user wali (user terhubung ke tabel wali via users.wali_id)
$stmt = $pdo->prepare("SELECT w.id FROM wali w JOIN users u ON u.wali_id = w.id WHERE u.id = ?");
$stmt->execute([$uid]);
$w = $stmt->fetch();
$anak = [];
if ($w) {
  $q = $pdo->prepare("SELECT s.* FROM santri s JOIN santri_wali sw ON sw.santri_id=s.id WHERE sw.wali_id=? ORDER BY s.nama");
  $q->execute([$w['id']]);
  $anak = $q->fetchAll();
}
?>
<h4>Anak Saya</h4>
<?php if (!$anak): ?>
  <div class="alert alert-info">Belum ada anak yang terhubung ke akun ini.</div>
<?php else: ?>
  <div class="list-group">
    <?php foreach ($anak as $a): ?>
      <a class="list-group-item list-group-item-action" href="wali_progress.php?sid=<?= $a['id'] ?>">
        <?= htmlspecialchars($a['nama']) ?> — Kelas: <?= htmlspecialchars($a['kelas_id'] ?? '-') ?>
      </a>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
<?php require __DIR__ . '/../includes/footer.php'; ?>
