<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/rbac.php';
require_login(); require_role(['admin','guru']);
require __DIR__ . '/../includes/header.php';

if (isset($_GET['delete'])) {
  $id = (int)$_GET['delete'];
  $pdo->prepare("DELETE FROM wali WHERE id=?")->execute([$id]);
  header("Location: wali_list.php"); exit;
}
$rows = $pdo->query("SELECT * FROM wali ORDER BY nama")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4>Data Wali</h4>
  <a class="btn btn-primary" href="wali_form.php">Tambah Wali</a>
</div>
<div class="table-responsive">
<table class="table table-striped">
  <thead><tr><th>Nama</th><th>HP</th><th>Email</th><th>Aksi</th></tr></thead>
  <tbody>
  <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['nama']) ?></td>
      <td><?= htmlspecialchars($r['hp']) ?></td>
      <td><?= htmlspecialchars($r['email']) ?></td>
      <td>
        <a class="btn btn-sm btn-outline-secondary" href="wali_form.php?id=<?= $r['id'] ?>">Edit</a>
        <a class="btn btn-sm btn-outline-danger" href="?delete=<?= $r['id'] ?>" onclick="return confirm('Hapus data?')">Hapus</a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
