<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require_login();
require __DIR__ . '/../includes/header.php';
$rows = $pdo->query("SELECT p.*, u.name AS author FROM pengumuman p LEFT JOIN users u ON u.id=p.dibuat_oleh ORDER BY p.created_at DESC")->fetchAll();
?>
<h4>Pengumuman</h4>
<ul class="list-group">
  <?php foreach ($rows as $r): ?>
    <li class="list-group-item">
      <div class="d-flex justify-content-between">
        <strong><?= htmlspecialchars($r['judul']) ?></strong>
        <small><?= htmlspecialchars($r['created_at']) ?> — <?= htmlspecialchars($r['author'] ?? 'Admin') ?></small>
      </div>
      <div><?= htmlspecialchars($r['isi']) ?></div>
    </li>
  <?php endforeach; ?>
</ul>
<?php require __DIR__ . '/../includes/footer.php'; ?>
