<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require_login();
require __DIR__ . '/../includes/header.php';

$sid = (int)($_GET['sid'] ?? 0);
$santri = $pdo->prepare("SELECT * FROM santri WHERE id=?"); $santri->execute([$sid]); $santri = $santri->fetch();
if (!$santri) { die("Data tidak ditemukan"); }
$abs = $pdo->prepare("SELECT tanggal,status FROM absensi WHERE santri_id=? ORDER BY tanggal DESC LIMIT 30"); $abs->execute([$sid]); $abs = $abs->fetchAll();
$haf = $pdo->prepare("SELECT tanggal,materi,catatan FROM hafalan WHERE santri_id=? ORDER BY tanggal DESC LIMIT 30"); $haf->execute([$sid]); $haf = $haf->fetchAll();
?>
<h4>Perkembangan: <?= htmlspecialchars($santri['nama']) ?></h4>
<div class="row g-3">
  <div class="col-md-6">
    <div class="card h-100">
      <div class="card-body">
        <h5 class="card-title">Absensi Terakhir</h5>
        <ul class="list-group">
          <?php foreach ($abs as $a): ?>
            <li class="list-group-item d-flex justify-content-between"><span><?= htmlspecialchars($a['tanggal']) ?></span><span><?= htmlspecialchars($a['status']) ?></span></li>
          <?php endforeach; ?>
        </ul>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card h-100">
      <div class="card-body">
        <h5 class="card-title">Hafalan Terakhir</h5>
        <ul class="list-group">
          <?php foreach ($haf as $h): ?>
            <li class="list-group-item"><strong><?= htmlspecialchars($h['tanggal']) ?>:</strong> <?= htmlspecialchars($h['materi']) ?> <em><?= htmlspecialchars($h['catatan']) ?></em></li>
          <?php endforeach; ?>
        </ul>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
